//********************************************************************;
//*                                                                  *;
//*  Intel(R) Confidential                                           *;
//*                                                                  *;
//*  TXTINFO64   Tool                                                *;
//*                                                                  *;
//*  Copyright (c) 2009 Intel Corp.                                  *;
//*                                                                  *;
//*  This code has been developed by Intel Corporation.              *;
//*  Licensee has Intel's permission to incorporate this source code *;
//*  into their product, royalty free.  This source code may NOT be  *;
//*  redistributed to anyone without Intel's written permission.     *;
//*                                                                  *;
//*  Intel specifically disclaims all warranties, express or         *;
//*  implied, and all liability, including consequential and other   *;
//*  indirect damages, for the use of this code, including liability *;
//*  for infringement of any proprietary rights, and including the   *;
//*  warranties of merchantability and fitness for a particular      *;
//*  purpose.  Intel does not assume any responsibility for any      *;
//*  errors which may appear in this code nor any responsibility to  *;
//*  update it.                                                      *;
//*                                                                  *;
//********************************************************************;

#ifndef _TPM_TIS
#define _TPM_TIS
//#include "TpmTIS.h"
#include "ShellLib.h"

//windows includes
#include "stdafx.h"

/********************Function pointer to status check function******************/
//typedef void (*TPM_STATUS_CHECK_PROC) ();
//typedef UINT8 TPM_AUTHDATA[20];
//typedef TPM_AUTHDATA TPM_ENCAUTH;
//CHAR16 *ptr;
#define MAX_FILE_LENGTH 32
/***************************TPM Locality 0 Base*****************************************/
#define TPM_BASE_0	0x0FED40000


/******************************Command Retry Count*******************************************/
#define TPM_CMD_RETRY_COUNT	1
/*******************************TPM Command Tags*************************************/
#define TPM_TAG_RQU_COMMAND			0x00C1 // A command with no authentication.
#define TPM_TAG_RQU_AUTH1_COMMAND	0x00C2 // An authenticated command with one authentication handle
#define TPM_TAG_RQU_AUTH2_COMMAND	0x00C3 // An authenticated command with two authentication handles
#define TPM_TAG_RSP_COMMAND			0x00C4 // A response from a command with no authentication
#define TPM_TAG_RSP_AUTH1_COMMAND	0x00C5 // An authenticated response with one authentication handle
#define TPM_TAG_RSP_AUTH2_COMMAND	0x00C6 // An authenticated response with two authentication handles

/*******************************TPM Command Ordinals*************************************/

#define TPM_ORD_OIAP                          10
#define TPM_ORD_OSAP                          11
#define TPM_ORD_ChangeAuth                    12
#define TPM_ORD_TakeOwnership                 13
#define TPM_ORD_ChangeAuthAsymStart           14
#define TPM_ORD_ChangeAuthAsymFinish          15

#define TPM_ORD_Extend                        20
#define TPM_ORD_PcrRead                       21
#define TPM_ORD_Quote                         22
#define TPM_ORD_Seal                          23
#define TPM_ORD_Unseal                        24
#define TPM_ORD_DirWriteAuth                  25
#define TPM_ORD_DirRead                       26

#define TPM_ORD_UnBind                        30
#define TPM_ORD_CreateWrapKey                 31
#define TPM_ORD_LoadKey                       32
#define TPM_ORD_GetPubKey                     33
#define TPM_ORD_EvictKey                      34

#define TPM_ORD_CreateMigrationBlob           40
#define TPM_ORD_ReWrapKey                     41
#define TPM_ORD_ConvertMigrationBlob          42
#define TPM_ORD_AuthorizeMigrationKey         43
#define TPM_ORD_CreateMaintenanceArchive      44
#define TPM_ORD_LoadMaintenanceArchive        45
#define TPM_ORD_KillMaintenanceFeature        46
#define TPM_ORD_LoadManuMaintPub              47
#define TPM_ORD_ReadManuMaintPub              48

#define TPM_ORD_CertifyKey                    50

#define TPM_ORD_Sign                          60

#define TPM_ORD_GetRandom                     70
#define TPM_ORD_StirRandom                    71

#define TPM_ORD_SelfTestFull                  80
#define TPM_ORD_SelfTestStartup               81
#define TPM_ORD_CertifySelfTest               82
#define TPM_ORD_ContinueSelfTest              83
#define TPM_ORD_GetTestResult                 84

#define TPM_ORD_Reset                         90
#define TPM_ORD_OwnerClear                    91
#define TPM_ORD_DisableOwnerClear             92
#define TPM_ORD_ForceClear                    93
#define TPM_ORD_DisableForceClear             94

#define TPM_ORD_GetCapabilitySigned           100
#define TPM_ORD_GetCapability                 101
#define TPM_ORD_GetCapabilityOwner            102

#define TPM_ORD_OwnerSetDisable               110
#define TPM_ORD_PhysicalEnable                111
#define TPM_ORD_PhysicalDisable               112
#define TPM_ORD_SetOwnerInstall               113
#define TPM_ORD_PhysicalSetDeactivated        114
#define TPM_ORD_SetTempDeactivated            115

#define TPM_ORD_CreateEndorsementKeyPair      120
#define TPM_ORD_MakeTPMIdentity               121
#define TPM_ORD_ActivateTPMIdentity           122
#define TPM_ORD_ReadPubek                     124
#define TPM_ORD_OwnerReadPubek                125
#define TPM_ORD_DisablePubekRead              126

#define TPM_ORD_GetAuditEvent                 130
#define TPM_ORD_GetAuditEventSigned           131

#define TPM_ORD_GetOrdinalAuditStatus         140
#define TPM_ORD_SetOrdinalAuditStatus         141
#define TPM_ORD_GetOrdinalStatusSigned        142

#define TPM_ORD_Terminate_Handle              150
#define TPM_ORD_Init                          151
#define TPM_ORD_SaveState                     152
#define TPM_ORD_Startup                       153
#define TPM_ORD_SetRedirection                154

#define TPM_ORD_SHA1Start                     160
#define TPM_ORD_SHA1Update                    161
#define TPM_ORD_SHA1Complete                  162
#define TPM_ORD_SHA1CompleteExtend            163

#define TPM_ORD_FieldUpgrade                  170

#define TPM_ORD_NV_DefineSpace                204
#define TPM_ORD_NV_WriteValue                 205
#define TPM_ORD_NV_ReadValue                  207

#define TSC_ORD_PhysicalPresence              0x4000000A
#define TSC_ORD_ResetEstablishmentBit         0x4000000B


#define TPM_PROTECTED_COMMAND	0
#define TPM_ORD_PCRRead			TPM_PROTECTED_COMMAND + 21
#define TPM_ORD_PCR_Extend		TPM_PROTECTED_COMMAND + 20
#define TPM_ORD_PCR_Reset		TPM_PROTECTED_COMMAND + 200
#define TPM_ORD_GetCapability	TPM_PROTECTED_COMMAND + 101
#define TPM_ORD_NV_ReadValue	TPM_PROTECTED_COMMAND + 207


/****************************NVIndexes****************************************/
#define INDEX_LCP_DEF       0x50000001
#define INDEX_LCP_DEF_SIZE  54

#define INDEX_LCP_OWN       0x40000001
#define INDEX_LCP_OWN_SIZE  54

#define INDEX_AUX_2         0x50000002
#define INDEX_AUX_3         0x50000003
#define INDEX_AUX_SIZE      96

/****************************TPM Capability Flags********************************************/
#define TPM_CAP_ORD                           (UINT32)(0x00000001)
#define TPM_CAP_ALG                           (UINT32)(0x00000002)
#define TPM_CAP_PID                           (UINT32)(0x00000003)
#define TPM_CAP_FLAG                          (UINT32)(0x00000004)
#define TPM_CAP_PROPERTY                      (UINT32)(0x00000005)
#define TPM_CAP_VERSION                       (UINT32)(0x00000006)
#define TPM_CAP_KEY_HANDLE                    (UINT32)(0x00000007)
#define TPM_CAP_CHECK_LOADED                  (UINT32)(0x00000008)
#define TPM_CAP_BIT_OWNER                     (UINT32)(0x00000009)
#define TPM_CAP_BIT_LOCAL                     (UINT32)(0x0000000A)
#define TPM_CAP_DELEGATIONS                   (UINT32)(0x0000000B)
#define TPM_CAP_KEY_STATUS                    (UINT32)(0x0000000C)
#define TPM_CAP_NV_LIST                       (UINT32)(0x0000000D)
#define TPM_CAP_TABLE_ADMIN                   (UINT32)(0x0000000E)
#define TPM_CAP_TABLE_ENABLE                  (UINT32)(0x0000000F)
#define TPM_CAP_MFR                           (UINT32)(0x00000010)
#define TPM_CAP_NV_INDEX                      (UINT32)(0x00000011)
#define TPM_CAP_TRANS_ALG                     (UINT32)(0x00000012)
#define TPM_CAP_GPIO_CHANNEL                  (UINT32)(0x00000013)
#define TPM_CAP_HANDLE                        (UINT32)(0x00000014)
#define TPM_CAP_TRANS_ES                      (UINT32)(0x00000015)
#define TPM_CAP_AUTH_ENCRYPT                  (UINT32)(0x00000017)
#define TPM_CAP_SELECT_SIZE                   (UINT32)(0x00000015)
#define TPM_CAP_DA_LOGIC                      (UINT32)(0x00000019)
#define TPM_CAP_VERSION_VAL                   (UINT32)(0x0000001A)
#define TPM_CAP_FLAG_PERMANENT				  (UINT32)(0x108)
#define TPM_CAP_FLAG_VOLATILE				  (UINT32)(0x109)
/****************************TPM Sub Capability Flags***************************************/
#define TPM_CAP_PROP_OWNER 		0x111
#define H_LEN	20
#define MAX_PCR_COUNT 18	//16 are normal and last two 

/****************************TPM Command Error Codes****************************************/
#define TPM_BASE				0
#define TPM_SUCCESS				TPM_BASE
#define TPM_VENDOR_ERROR		TPM_BASE + 0x400
#define TPM_NON_FATAL			TPM_BASE + 0x800
#define TPM_RETRY				TPM_BASE + TPM_NON_FATAL
#define TPM_INVALID_POSTINIT	TPM_BASE + 38

/****************************TPM driver errors****************************************/
#define TCG_OK						0x0			// Indicator of successful execution of the function.
#define TCG_GENERAL_ERROR			TPM_BASE + 0x01	// A general unidentified error occurred.
#define TCG_TPM_IS_LOCKED			TPM_BASE + 0x02	// The access cannot be granted the device is open.
#define TCG_NO_RESPONSE				TPM_BASE + 0x03	// No response from the TPM device.
#define TCG_INVALID_RESPONSE		TPM_BASE + 0x04	// The response from the TPM was invalid.
#define TCG_INVALID_ACCESS_REQUEST	TPM_BASE + 0x05	// The access parameters for this function are invalid.
#define TCG_FIRMWARE_ERROR			TPM_BASE + 0x06	// Firmware error during start up.
#define TCG_INTEGRITY_CHECK_FAILED	TPM_BASE + 0x07	// Integrity checks of TPM parameter failed.
#define TCG_INVALID_DEVICE_ID		TPM_BASE + 0x08	// The device ID for the TPM is invalid.
#define TCG_INVALID_VENDOR_ID		TPM_BASE + 0x09	// The vendor ID for the TPM is invalid.
#define TCG_UNABLE_TO_OPEN			TPM_BASE + 0x0A	// Unable to open a connection to the TPM device.
#define TCG_UNABLE_TO_CLOSE			TPM_BASE + 0x0B	// Unable to close a connection to the TPM device.
#define TCG_RESPONSE_TIMEOUT		TPM_BASE + 0x0C	// Time out for TPM response.
#define TCG_INVALID_COM_REQUEST		TPM_BASE + 0x0D	// The parameters for the communication access are invalid.
#define TCG_INVALID_ADR_REQUEST		TPM_BASE + 0x0E	// The address parameter for the access is invalid.
#define TCG_WRITE_BYTE_ERROR		TPM_BASE + 0x0F	// Bytes write error on the interface.
#define TCG_READ_BYTE_ERROR			TPM_BASE + 0x10	// Bytes read error on the interface.
#define TCG_BLOCK_WRITE_TIMEOUT		TPM_BASE + 0x11	// Blocks write error on the interface.
#define TCG_CHAR_WRITE_TIMEOUT		TPM_BASE + 0x12	// Bytes write time out on the interface.
#define TCG_CHAR_READ_TIMEOUT		TPM_BASE + 0x13	// Bytes read time out on the interface.
#define TCG_BLOCK_READ_TIMEOUT		TPM_BASE + 0x14	// Blocks read error on the interface.
#define TCG_TRANSFER_ABORT			TPM_BASE + 0x15	// Transfer abort in communication with TPM device. 
#define TCG_INVALID_DRV_FUNCTION	TPM_BASE + 0x16	// Function number (AL-Register) invalid for this driver.
#define TCG_OUTPUT_BUFFER_TOO_SHORT	TPM_BASE + 0x17	// Output buffer for the TPM response to short.
#define TCG_FATAL_COM_ERROR			TPM_BASE + 0x18	// Fatal error in TPM communication.
#define TCG_INVALID_INPUT_PARA		TPM_BASE + 0x19	// Input parameter for the function invalid.
#define TCG_TCG_COMMAND_ERROR		TPM_BASE + 0x20	// Error during execution of a TCG command.
#define TCG_INTERFACE_SHUTDOWN		TPM_BASE + 0x21	// TPM BIOS I/F has been shutdown using TCG_ShutdownPreBootInterface
#define TCG_PC_UNSUPPORTED			TPM_BASE + 0x22	// The requested function is not supported.
#define TCG_PC_TPM_NOT_PRESENT		TPM_BASE + 0x23	// TPM is not installed.
#define TCG_PC_TPM_DEACTIVATED		TPM_BASE + 0x24	// TPM is deactivated.
#define TCG_CMD_OVER_UNDER_WRITE	TPM_BASE + 0x25	// TPM is deactivated.

/***************************************TPM STATUS CHECK CODES****************************/
#define TPM_STATUS_SUCCESS	0
#define TPM_STATUS_FAILURE	1

/***************************************TPM LCP Constants*********************************/
#define LCP_POLHALG_SHA1 0
#define LCP_POLTYPE_LIST 0
#define LCP_POLTYPE_ANY 1
#define LCP_MAX_LISTS 8

/*****************************************************************************************/
#pragma pack (push,1)

#define BYTETOBINARYPATTERN "%d%d%d%d%d%d%d%d"
#define BYTETOBINARY(byte)  \
  (byte & 0x80 ? 1 : 0), \
  (byte & 0x40 ? 1 : 0), \
  (byte & 0x20 ? 1 : 0), \
  (byte & 0x10 ? 1 : 0), \
  (byte & 0x08 ? 1 : 0), \
  (byte & 0x04 ? 1 : 0), \
  (byte & 0x02 ? 1 : 0), \
  (byte & 0x01 ? 1 : 0) 

typedef struct _TPM {
	UINT8   ACCESS;				// 0
	UINT8   ignore[0x17];		// 1
	union{
		UINT16 Raw;				// 0x18
		struct{
			UINT8 LOW;
			UINT8 HIGH;
		}Bytes;
	}STS;
	UINT8   ignore2[0xA];		// 0x1A
	UINT8   DATA_FIFO;			// 0x24
	UINT8   ignore3[0xEDB];		// 0x25
	UINT16  TPM_VID;			// 0xF00
	UINT16  TPM_DID;			// 0xF02
	UINT8   TPM_RID;			// 0xF04
} TPM;

/********************************************************************/

typedef struct _TPM_HEADER_IN{
	UINT16 tag;
	UINT32 paramSize;
	UINT32 ordinal;
} TPM_Header_In;

typedef struct _TPM_HEADER_OUT{
	UINT16 tag;
	UINT32 paramSize;
	UINT32 returnCode;
} TPM_Header_Out;

/**************************TIS Conversion definitions****************************/

typedef UINT8 TPM_AUTHDATA[20];

//Command input structures
typedef struct _TPM_1_2_CMD_HEADER {
	UINT16 tag;
	UINT32 paramSize;
	UINT32 ordinal;
} TPM_1_2_CMD_HEADER;

typedef struct _TPM_1_2_GETCAP_PARAMS_IN {
	UINT32 capArea;
	UINT32 subCapSize;
	UINT32 subCap;
} TPM_1_2_GETCAP_PARAMS_IN;

typedef struct _TPM_1_2_PCRREAD_PARAMS_IN {
	UINT32 pcrIndex;
} TPM_1_2_PCRREAD_PARAMS_IN;

typedef struct _TPM_1_2_NV_READVALUE_IN{
	UINT32 nvIndex;
	UINT32 offset;
	UINT32 dataSize;
} TPM_1_2_NV_READVALUE_IN;

typedef struct _TPM_1_2_NV_WRITEVALUE_IN{
  UINT32    	nvIndex;
  UINT32        offset;
  UINT32        dataSize;
  //UINT8         data[1]; // variable size
} TPM_1_2_NV_WRITEVALUE_IN;    // variable size

#define SHA1_DIGEST_SIZE 20
typedef struct {
	UINT8  Digest[SHA1_DIGEST_SIZE];
} TCG_DIGEST;

typedef struct {
	UINT8 Sha1[20];
} DIGEST;
typedef struct {
	UINT16 SizeOfSelect;
	UINT8  PcrSelect[1];
} TPM_1_2_PCR_SELECTION;

typedef struct _TPM_1_2_PCR_INFO_SHORT {
	TPM_1_2_PCR_SELECTION     	pcrSelection; // variable size
	UINT8   					localityAtRelease;
	TCG_DIGEST    				digestAtRelease;
} TPM_1_2_PCR_INFO_SHORT; // variable size

typedef struct _TPM_1_2_NV_ATTRIBUTES {
	UINT16       tag;
	UINT32       attributes;
} TPM_1_2_NV_ATTRIBUTES;

typedef struct _TPM_1_2_PCR_EXTEND {
	UINT32      pcrNum;
	UINT8  		inDigest[SHA1_DIGEST_SIZE];
} TPM_1_2_PCR_EXTEND;


typedef struct _TPM_1_2_NV_DATA_PUBLIC {
	UINT16	Tag0;					//1800	 Start of TPM_NV_DATA_PUBLIC33	
	UINT32	indexValue;				//--in TPM order- ex:01000050
									//--Start (tdTPM_PCR_INFO_SHORT3)
									//----Start (tdTPM_PCR_SELECTION3)
	UINT16	readSizeofSelect;		//0x0300	------Fixed value of 3 for this version
	UINT8	readPcrSelect [3];		//0,0,0	------End # pcrSelection - 
	UINT8 	readLocalityAtRelease;	//0x1F	----1F=Any Locality
	DIGEST	readDigestAtRelease;	//0	---- 
									//----End # PCR_INFO_SHORT3 (26 bytes)
									//--Start (tdTPM_PCR_INFO_SHORT3)
									//----Start (tdTPM_PCR_SELECTION3)
	UINT16	writeSizeofSelect;		//0x0300	------Fixed value of 3 for this version
	UINT8	writePcrSelect[3];		//0,0,0	------End # pcrSelection - 
	UINT8	writeLocalityAtRelease;	//0x1F	----1F=Any Locality
	DIGEST	writeDigestAtRelease;	//0 	---- 
									//----End # PCR_INFO_SHORT3 (26 bytes)
									//--Start permission (tdTPM_NV_ATTRIBUTES)
	UINT16	Tag1;					//0x1700	----
	UINT32	Attributes;				//0	----see Table 12 NV Index Attribute Values
	UINT8	bReadSTClear;  			//0	----
	UINT8	bWriteSTClear;			//0	----
	UINT8	bWriteSDefine;  		//0	----
									//----End TPM_NV_ATTRIBUTES (9 bytes)
	UINT32	dataSize;				//0 --
	
} TPM_1_2_NV_DATA_PUBLIC; // variable size

//Command output structures
typedef struct _TPM_1_2_RET_HEADER {
	UINT16 tag;
	UINT32 paramSize;
	UINT32 returnCode;
} TPM_1_2_RET_HEADER;

typedef struct _TPM_1_2_GETCAP_OUT {
	UINT32 respSize; // Length of returned capability response
	UINT8  resp[256]; //<TODO> Need to make it dynamic
} TPM_1_2_GETCAP_OUT;

typedef struct _TPM_1_2_PCRREAD_OUT{
	UINT32 outDigest[H_LEN];
} TPM_1_2_PCRREAD_OUT;

typedef struct _TPM_1_3_NV_READVALUE_OUT{
	UINT32 dataSize;
	UINT8  data[256];
} TPM_1_3_NV_READVALUE_OUT;

typedef struct _TPM_1_2_KEY_PARMS {	// expected values:
	UINT32	algorithmID; 	//TPM_ALG_RSA = 0x00000001
	UINT16	encScheme; 		// TPM_ES_RSAESOAEP_SHA1_MGF1 = 0x0003
	UINT16	sigScheme; 		// TPM_SS_NONE = 0x0001
	UINT32 	parmSize;		// Should be 12 (0x0c)
	UINT32 	keyLength;		// 2048 (0x00000800)
	UINT32 	numPrimes;  	// 2
	UINT32 	exponentSize; 	// 0x0
	//UINT8* 	exponent; 		// omitted
} TPM_1_2_KEY_PARMS;
/*
typedef struct tdTPM_KEY_PARMS {
1251 TPM_ALGORITHM_ID algorithmID;
1252 TPM_ENC_SCHEME encScheme;
1253 TPM_SIG_SCHEME sigScheme;
1254 UINT32 parmSize;
1255 [size_is(parmSize)] BYTE* parms;
1256 } TPM_KEY_PARMS;
*/
typedef struct _TPM_1_2_PUBKEY_OUT {	// expected values:
	TPM_1_2_KEY_PARMS	keyParams; 		//TPM_ALG_RSA = 0x00000001
	UINT32 	pubKeyLength;				//  Should be 12 (0x0c)
	UINT8 	pubKey[256];				// 2048 (0x00000800)
	UINT8 	checksum[20];
} TPM_1_2_PUBKEY_OUT;

typedef struct _TPM_1_2_OIAP_OUT {	// expected values:
	UINT32 	authhandle;				//  value to use in take ownership command
	UINT8 	nonceEven[20];			//  value to use in take ownership command
} TPM_1_2_OIAP_OUT;


typedef struct _TPM_1_2_KEY{ 
	UINT8 	major; 			//must be 1
	UINT8 	minor; 			//must be 1
	UINT8 	revMajor; 		//dont care
	UINT8 	revMinor; 		//dont care
	UINT16 	keyUsage; 		// TPM_KEY_STORAGE = 0x0011
	UINT32 	keyFlags; 		// 0 
	UINT8 	authDataUsage; 	// TPM_AUTH_NEVER = 0 
	UINT32 	algorithmID; 	// TPM_ALG_RSA = 1
	UINT16 	encScheme; 		// TPM_ES_RSAESOAEP_SHA1_MGF1 = 3
	UINT16 	sigScheme;		// TPM_SS_NONE = 1
	UINT32 	keyParmSize;		// 0x0000000c	12 bytes
	UINT32 	RsaKeyLength;	// 0x00000800	In bits
	UINT32 	numPrimes;		// 0x00000002	Default is 2
	UINT32 	exponentSize;	// Must be 0	Use default size		
	UINT32 	PCRInfoSize; 	// Must be 0
	UINT32 	keyLength; 		// Must be 256
	UINT8  	key[256]; 		// currently we dont care
	UINT32 	encDataSize; 	// Must be zero for our use
	//[size_is(encDataSize)] BYTE* encData; not used
} TPM_1_2_KEY;

typedef struct _TPM_1_2_TAKE_OWNERSHIP {
	UINT16			protocolID;
	UINT32  		encOwnerAuthSize;
	UINT8			encOwnerAuth[256];
	UINT32			encSrkAuthSize;
	UINT8			encSrkAuth[256];
	TPM_1_2_KEY 	tpmKey;
	UINT32			authHandle;
	UINT8			nonceOdd[20];
	UINT8			continueAuthSession;
	UINT8			ownerAuth[20];
} TPM_1_2_TAKE_OWNERSHIP;

typedef struct _TPM_1_2_TAKE_OWNERSHIP_OUT {
	UINT16			protocolID;
	UINT32  		encOwnerAuthSize;
	UINT8			encOwnerAuth[256];
	UINT32			encSrkAuthSize;
	UINT8			encSrkAuth[256];
	TPM_1_2_KEY 	tpmKey;
	UINT32			authHandle;
	UINT8			nonceOdd[20];
	UINT8			continueAuthSession;
	UINT8			ownerAuth[20];
} TPM_1_2_TAKE_OWNERSHIP_OUT;

typedef struct _TIS_BUFFER_INFO {
	UINT8                             *Buffer;
	UINT32                             Size;
} TIS_BUFFER_INFO;


/*************************TPM Capability Flags***********************************/

typedef struct _TPM_PERMANENT_FLAGS {
  UINT16  tag;
  UINT8  disable;
  UINT8  ownership;
  UINT8  deactivated;
  UINT8  readPubek;
  UINT8  disableOwnerClear;
  UINT8  allowMaintenance;
  UINT8  physicalPresenceLifetimeLock;
  UINT8  physicalPresenceHWEnable;
  UINT8  physicalPresenceCMDEnable;
  UINT8  SECPUsed;
  UINT8  TPMPost;
  UINT8  TPMPostLock;
  UINT8  FIPS;
  UINT8  optr; //operator
  UINT8  enableRevokeEK;
  UINT8  nvLocked;
  UINT8  readSPKPub;
  UINT8  tpmEstablished;
} TPM_1_2_PERMANENT_FLAGS;

typedef struct _TPM_STCLEAR_FLAGS {
  UINT16 tag;
  UINT8  deactivated;
  UINT8  disableForceClear;
  UINT8  physicalPresence;
  UINT8  physicalPresenceLock;
  UINT8  bGlobalLock;
} TPM_1_2_STCLEAR_FLAGS;


/***********TPM Policy structs*******************/
typedef struct {
	UINT8 Sha1[20];
} LCP_HASH;

typedef struct {								//bytes
	UINT16 Version;									//2
	UINT8 HashAlg; // one of LCP_POLHALG_*			//3
	UINT8 PolicyType; // one of LCP_POLTYPE_*		//4
	UINT8 SINITMinVersion;							//5
	UINT8 Reserved1;								//6
	UINT16 DataRevocationCounters[LCP_MAX_LISTS];	//22
	UINT32 PolicyControl;							//26
	UINT32 Reserved2[2];							//34
	LCP_HASH PolicyHash;							//
} LCP_POLICY;

/***************TPM Command Define space****/



typedef struct {
	UINT16 	tag;
	UINT32 	paramSize;
	UINT32	Ordinal;				//0xCC000000	 TPM_ORD_NV_DEFINESPACE
	UINT16	Tag0;					//1800	 Start of TPM_NV_DATA_PUBLIC33	
	UINT32	indexValue;				//--in TPM order- ex:01000050
									//--Start (tdTPM_PCR_INFO_SHORT3)
									//----Start (tdTPM_PCR_SELECTION3)
	UINT16	readSizeofSelect;		//0x0300	------Fixed value of 3 for this version
	UINT8	readPcrSelect [3];		//0,0,0	------End # pcrSelection - 
	UINT8 	readLocalityAtRelease;	//0x1F	----1F=Any Locality
	DIGEST	readDigestAtRelease;	//0	---- 
									//----End # PCR_INFO_SHORT3 (26 bytes)
									//--Start (tdTPM_PCR_INFO_SHORT3)
									//----Start (tdTPM_PCR_SELECTION3)
	UINT16	writeSizeofSelect;		//0x0300	------Fixed value of 3 for this version
	UINT8	writePcrSelect[3];		//0,0,0	------End # pcrSelection - 
	UINT8	writeLocalityAtRelease;	//0x1F	----1F=Any Locality
	DIGEST	writeDigestAtRelease;	//0 	---- 
									//----End # PCR_INFO_SHORT3 (26 bytes)
									//--Start permission (tdTPM_NV_ATTRIBUTES)
	UINT16	Tag1;					//0x1700	----
	UINT32	Attributes;				//0	----see Table 12 NV Index Attribute Values
	UINT8	bReadSTClear;  			//0	----
	UINT8	bWriteSTClear;			//0	----
	UINT8	bWriteSDefine;  		//0	----
									//----End TPM_NV_ATTRIBUTES (9 bytes)
	UINT32	dataSize;				//0 --
									// --END of TPM_NV_DATA_PUBLIC (71 bytes)
	DIGEST	encAuthValue;			//0 encrypted  auth value 
									//End of DefineSpace parameters ( 95 bytes)
} TPM_DEFINE_SPACE;

typedef struct {
	CHAR16	fileSig[8]; 			//TpmNvDef	fixed value confirms this is a DEF file
	UINT8	majorVersion;			//0x01	 rolls when structure changes are not backward compatible 
	UINT8	minorVersion;			//0x00	 rolls when defining reserved fields or appending additional fields
	UINT16	tpmVersion;				//0x0102	TPM version (1.2, or 2.0)
	UINT8	reserved0[4];			//0 reserved for future definition
	TPM_DEFINE_SPACE defSpace;
	DIGEST	authValue;				//0 plain text auth value to be encrypted
	UINT8	reserved1[1];			//0	reserved for future definition

} DEF_STRUCT;

typedef struct {
	UINT32	indexValue;
	UINT32 	fileOffset;
	UINT32	numBytes;
	UINT32 	indexOffset;
	UINT8	buffer[256];
}	NV_DATA;
/***************End TPM Command Define space****/


#pragma pack (pop)

/*******TPM Command Execution Function************/
UINT8 ExecuteTPMCmd(UINT8 *pu8InBuff, UINT32 u32InBuffLen, UINT8 *pu8OutBuff, UINT32 u32OutBuffLen);
UINT8 ExecuteTPMCmdSGL(IN UINT32 NumInputBuffers, IN TIS_BUFFER_INFO *InputBuffers, IN UINT32  NumOutputBuffers, IN OUT  TIS_BUFFER_INFO *OutputBuffers );
UINT32 TieSocketConfigure();
UINT32 TieSocketUnConfigure();
//UINT8 SendCmdBytesToTPM(UINT8 *pCmdBytes);
//UINT8 ReadTPMResponseBytes(UINT8 *pu8OutBuff);

int PlatformCommand( char cmd );

/*****************Helper Functions*****************/
UINT16 ChangeEndiannessWord(UINT16 u16Val);
UINT32 ChangeEndiannessDWord(UINT32 u32Val);

/****************TPM Status Check functions********************/
UINT8 tpmRegValidStsStatusCheck(void *pBuffer);
UINT8 activeLocalityStatusCheck(void *pBuffer);
UINT8 commandReadyStatusCheck(void *pBuffer);
UINT8 stsBurstCountValidStatusCheck(void *pBuffer);
UINT8 stsValidAndExpectStatusCheck(void *pBuffer);
UINT8 stsValidStatusCheck(void *pBuffer);
UINT8 stsValidAnddataAvailStatusCheck(void *pBuffer);

#endif //_TPM_TIS